from kyt import *
import subprocess
from telethon import events
from telethon.tl.custom import Button

# Pastikan fungsi valid() dan variabel DOMAIN sudah diimpor dari kyt.py

@bot.on(events.NewMessage(pattern=r"(?:.menu|/menu)$"))
@bot.on(events.CallbackQuery(data=b'menu'))
async def menu(event):
    # --- 1. Ambil Data Pengguna (User Info) ---
    sender = await event.get_sender()
    user_id = sender.id
    first_name = sender.first_name
    username = f"@{sender.username}" if sender.username else "No Username"
    
    # Validasi Hak Akses
    val = valid(str(user_id))
    
    if val == "false":
        msg_denied = f"""
<b>⚠️ AKSES DITOLAK</b>
──────────────────────
Maaf <b>{first_name}</b>, ID Anda <code>{user_id}</code>
Tidak terdaftar dalam database server ini.
Hubungi Admin untuk akses.
──────────────────────
"""
        try:
            await event.answer("Akses Ditolak!", alert=True)
        except:
            await event.reply(msg_denied, parse_mode='html')
            
    elif val == "true":
        # Notifikasi Loading (Opsional, biar terasa responsif di callback)
        if isinstance(event, events.CallbackQuery.Event):
            await event.answer("Memuat Dashboard...", alert=False)

        # --- 2. Eksekusi Command (Optimasi Script VPS) ---
        try:
            # SSH
            ssh = subprocess.check_output("awk -F: '$3 >= 1000 && $1 != \"nobody\" {print $1}' /etc/passwd | wc -l", shell=True).decode("ascii").strip()
            
            # XRAY (VMESS, VLESS, TROJAN - Menggunakan logic grep config.json)
            # Catatan: Perintah ini asumsi config ada di /etc/xray/config.json
            vms = subprocess.check_output('vmc=$(grep -c -E "^### " "/etc/xray/config.json"); echo $((vmc / 2))', shell=True).decode("ascii").strip()
            vls = subprocess.check_output('vlx=$(grep -c -E "^#& " "/etc/xray/config.json"); echo $((vlx / 2))', shell=True).decode("ascii").strip()
            trj = subprocess.check_output('trx=$(grep -c -E "^#! " "/etc/xray/config.json"); echo $((trx / 2))', shell=True).decode("ascii").strip()
            
            # INFO SYSTEM
            namaos = subprocess.check_output("cat /etc/os-release | grep -w PRETTY_NAME | head -n1 | sed 's/=//g' | sed 's/PRETTY_NAME//g' | sed 's/\"//g'", shell=True).decode("ascii").strip()
            ipsaya = subprocess.check_output("curl -s ipv4.icanhazip.com", shell=True).decode("ascii").strip()
            city = subprocess.check_output("cat /root/.info/.city 2>/dev/null || echo 'Unknown'", shell=True).decode("ascii").strip()
            
        except Exception as e:
            # Fallback jika terjadi error saat mengambil data
            ssh = vms = vls = trj = "Err"
            namaos = "Ubuntu Linux"
            ipsaya = "127.0.0.1"
            city = "Server"

        # --- 3. Tampilan Pesan Premium (HTML Mode) ---
        msg = f"""
<b>👑 PREMIUM CONTROL PANEL</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 USER INFORMATION</b>
🆔 <b>ID :</b> <code>{user_id}</code>
👻 <b>User :</b> {username}
👋 <b>Name :</b> {first_name}

<b>💻 SERVER INFORMATION</b>
🖥 <b>OS :</b> <code>{namaos}</code>
📍 <b>Loc :</b> <code>{city}</code>
📡 <b>IP :</b> <code>{ipsaya}</code>
🌐 <b>Domain :</b> <code>{DOMAIN}</code>

<b>📊 TUNNEL STATUS</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
☁️ <b>SSH OVPN :</b> <code>{ssh}</code> Accounts
⚡ <b>VMESS GW :</b> <code>{vms}</code> Accounts
🚀 <b>VLESS GW :</b> <code>{vls}</code> Accounts
🛡 <b>TROJAN GW :</b> <code>{trj}</code> Accounts
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Silakan pilih menu manajemen di bawah:</i>
"""

        # --- 4. Tampilan Tombol Modern (Grid 2x2) ---
        inline = [
            [Button.inline("☁️ SSH OVPN", data="ssh"), Button.inline("⚡ VMESS", data="vmess")],
            [Button.inline("🚀 VLESS", data="vless"), Button.inline("🛡 TROJAN", data="trojan")],
            [Button.inline("👻 SHADOWSOCKS", data="shadowsocks"), Button.inline("⚙️ SETTINGS", data="setting")],
            [Button.inline("🖥 SERVICE STATUS", data="info")],
            [Button.inline("🔄 REFRESH DATA", data="menu")]
        ]

        # --- 5. Mengirim Pesan ---
        # Gunakan parse_mode='html' agar tebal/miring berfungsi
        try:
            await event.edit(msg, buttons=inline, parse_mode='html')
        except Exception:
            # Jika pesan tidak bisa diedit (misal trigger dari /menu text biasa), maka reply
            await event.reply(msg, buttons=inline, parse_mode='html')