from kyt import *
import subprocess
import requests  # Penting untuk cek IP ke GitHub
import datetime as DT # Penting untuk hitung tanggal
from telethon import events
from telethon.tl.custom import Button

# =================================================================
# 1. REGIS IP INFO (PINDAHAN DARI SSH)
# =================================================================
@bot.on(events.CallbackQuery(data=b'regis'))
async def regis_ip_check(event):
    sender = await event.get_sender()
    if valid(str(sender.id)) != "true":
        await event.answer("Akses Ditolak", alert=True)
        return
    
    # Pesan Loading
    try:
        msg_wait = await event.edit("<b>🔄 Checking IP License...</b>", parse_mode='html')
    except:
        msg_wait = await event.respond("<b>🔄 Checking IP License...</b>", parse_mode='html')

    try:
        # 1. Ambil IP VPS
        try:
            my_ip = subprocess.check_output("curl -sS ipv4.icanhazip.com", shell=True).decode("utf-8").strip()
        except:
            my_ip = "Unknown IP"

        # 2. Ambil Data dari GitHub
        url_izin = "https://raw.githubusercontent.com/hokagelegend9999/ijin/refs/heads/main/alpha"
        try:
            r = requests.get(url_izin)
            data = r.text
        except:
            await msg_wait.edit("❌ <b>Error:</b> Gagal menghubungi GitHub.", parse_mode='html')
            return

        # 3. Parsing Data
        username = "Unregistered"
        exp_date = "-"
        status = "🔴 Expired / Unregistered"
        validity = "0 Days"
        
        found = False
        
        # Loop setiap baris di data github
        for line in data.splitlines():
            if my_ip in line:
                parts = line.split()
                if len(parts) >= 3:
                    username = parts[1]
                    exp_date = parts[2]
                    found = True
                    break
        
        # 4. Hitung Masa Aktif
        if found:
            try:
                today = DT.date.today()
                exp_dt = DT.datetime.strptime(exp_date, "%Y-%m-%d").date()
                diff = (exp_dt - today).days
                
                validity = f"{diff} Days"
                
                if diff >= 0:
                    status = "🟢 Active"
                else:
                    status = "🔴 Expired"
                    validity = "Expired"
            except:
                validity = "Error Date"
        
        # 5. Tampilkan Hasil
        msg = f"""
<b>📂 USER LICENSE STATUS</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🖥️ IP VPS     :</b> <code>{my_ip}</code>
<b>👤 Username   :</b> <code>{username}</code>
<b>📅 Expired    :</b> <code>{exp_date}</code>
<b>⏳ Validity   :</b> <code>{validity}</code>
<b>💎 Status     :</b> {status}
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
        await msg_wait.edit(msg, buttons=[[Button.inline("‹ Main Menu ›", "menu")]], parse_mode='html')

    except Exception as e:
        await msg_wait.edit(f"<b>❌ System Error:</b>\n<code>{str(e)}</code>", parse_mode='html')

# =================================================================
# 2. MENU UTAMA (UPDATE: TOMBOL BACK TO START)
# =================================================================
@bot.on(events.NewMessage(pattern=r"(?:.menu|/menu)$"))
@bot.on(events.CallbackQuery(data=b'menu'))
async def menu(event):
    # --- 1. Ambil Data Pengguna (User Info) ---
    sender = await event.get_sender()
    user_id = sender.id
    first_name = sender.first_name
    username = f"@{sender.username}" if sender.username else "No Username"
    
    # Validasi Hak Akses
    val = valid(str(user_id))
    
    if val == "false":
        msg_denied = f"""
<b>⚠️ AKSES DITOLAK</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
Maaf <b>{first_name}</b>, ID Anda <code>{user_id}</code>
Tidak terdaftar dalam database server ini.
Hubungi Admin untuk akses.
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
"""
        try:
            await event.answer("Akses Ditolak!", alert=True)
        except:
            await event.reply(msg_denied, parse_mode='html')
            
    elif val == "true":
        if isinstance(event, events.CallbackQuery.Event):
            await event.answer("Memuat Dashboard...", alert=False)

        # --- 2. Eksekusi Command (Optimasi Script VPS) ---
        try:
            # Perintah Bash satu baris
            ssh = subprocess.check_output("awk -F: '$3 >= 1000 && $1 != \"nobody\" {print $1}' /etc/passwd | wc -l", shell=True).decode("ascii").strip()
            vms = subprocess.check_output('vmc=$(grep -c -E "^### " "/etc/xray/config.json"); echo $((vmc / 2))', shell=True).decode("ascii").strip()
            vls = subprocess.check_output('vlx=$(grep -c -E "^#& " "/etc/xray/config.json"); echo $((vlx / 2))', shell=True).decode("ascii").strip()
            trj = subprocess.check_output('trx=$(grep -c -E "^#! " "/etc/xray/config.json"); echo $((trx / 2))', shell=True).decode("ascii").strip()
            
            namaos = subprocess.check_output("cat /etc/os-release | grep -w PRETTY_NAME | head -n1 | sed 's/=//g' | sed 's/PRETTY_NAME//g' | sed 's/\"//g'", shell=True).decode("ascii").strip()
            ipsaya = subprocess.check_output("curl -s ipv4.icanhazip.com", shell=True).decode("ascii").strip()
            # Ambil kota, jika file tidak ada return 'Server'
            city = subprocess.check_output("cat /root/.info/.city 2>/dev/null || echo 'Server'", shell=True).decode("ascii").strip()
            
        except Exception as e:
            ssh = vms = vls = trj = "0"
            namaos = "Ubuntu Linux"
            ipsaya = "127.0.0.1"
            city = "Unknown"

        # --- 3. Tampilan Pesan Premium (HTML Mode) ---
        msg = f"""
<b>👑 PREMIUM CONTROL PANEL</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 USER INFORMATION</b>
🆔 <b>ID :</b> <code>{user_id}</code>
👻 <b>User :</b> {username}
👋 <b>Name :</b> {first_name}

<b>💻 SERVER INFORMATION</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
🖥 <b>OS :</b> <code>{namaos}</code>
📍 <b>Loc :</b> <code>{city}</code>
📡 <b>IP :</b> <code>{ipsaya}</code>
🌐 <b>Domain :</b> <code>{DOMAIN}</code>

<b>📊 TUNNEL STATUS</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
☁️ <b>SSH OVPN :</b> <code>{ssh}</code> Accounts
⚡ <b>VMESS GW :</b> <code>{vms}</code> Accounts
🚀 <b>VLESS GW :</b> <code>{vls}</code> Accounts
🛡 <b>TROJAN GW :</b> <code>{trj}</code> Accounts
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<i>Silakan pilih menu manajemen di bawah:</i>
"""

        # --- 4. Tampilan Tombol Modern ---
        inline = [
            [Button.inline("☁️ SSH OVPN", data="ssh"), Button.inline("⚡ VMESS", data="vmess")],
            [Button.inline("🚀 VLESS", data="vless"), Button.inline("🛡 TROJAN", data="trojan")],
            [Button.inline("👻 SHADOWSOCKS", data="shadowsocks"), Button.inline("⚙️ SETTINGS", data="setting")],
            [Button.inline("🖥 SERVICE STATUS", data="info"), Button.inline("📝 REGIS IP", data="regis")],
            [Button.inline("🔄 REFRESH DATA", data="menu")],
            # [NEW] Tombol Kembali ke Start
            # Asumsi callback 'start' akan mentrigger handler /start jika ada
            # Jika tidak ada callback khusus, bisa pakai url="https://t.me/BotKamu?start=start"
            # Tapi cara paling umum adalah memanggil callback yg menghandle tampilan awal
            [Button.inline("🔙 BACK TO START", data="start")] 
        ]

        try:
            await event.edit(msg, buttons=inline, parse_mode='html')
        except Exception:
            await event.reply(msg, buttons=inline, parse_mode='html')
            
