from kyt import * # Import bot dan fungsi valid/auth dari file utama
from telethon import events, Button
import subprocess
import asyncio
import math
import time
import re
import json
import base64
import requests
import datetime as DT
import os

# =================================================================
# FUNGSI PEMBANTU (HELPER)
# =================================================================

def get_vmess_data():
    """Mengambil data user VMess dari config.json dengan Filter Unique User"""
    try:
        # Grep baris yang diawali "### " dari config Xray
        cmd = 'grep -E "^### " "/etc/xray/config.json"'
        raw_output = subprocess.check_output(cmd, shell=True).decode("utf-8")
        data_list = []
        seen_users = set() # Set untuk melacak user agar tidak ganda
        
        for line in raw_output.splitlines():
            if line.strip():
                parts = line.split()
                if len(parts) >= 3:
                    user = parts[1]
                    exp = parts[2]
                    # Filter: Jika user belum ada di set, masukkan list
                    if user not in seen_users:
                        data_list.append({"user": user, "exp": exp})
                        seen_users.add(user)
        return data_list
    except:
        return []

def render_page_content(data_list, page, mode="list", item_per_page=5):
    """
    Fungsi render satu pintu untuk Mode List dan Mode Delete.
    mode="list"   -> Menampilkan tombol Detail (🔍)
    mode="delete" -> Menampilkan tombol Hapus (🗑️)
    """
    total_items = len(data_list)
    total_pages = math.ceil(total_items / item_per_page)
    
    if page < 0: page = 0
    if total_pages > 0 and page >= total_pages: page = total_pages - 1
    if total_pages == 0: page = 0 
    
    start = page * item_per_page
    end = start + item_per_page
    sliced_data = data_list[start:end]
    
    # Header Pesan
    title = "⚡ LIST USER VMESS" if mode == "list" else "🗑️ DELETE USER VMESS"
    msg = f"<b>{title}</b>\n▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬\n"
    
    flat_buttons = [] # Wadah tombol datar sebelum dipotong
    
    if not sliced_data:
        msg += "<i>⚠️ Tidak ada user VMess.</i>"
    else:
        for row in sliced_data:
            user = row["user"]
            exp = row["exp"]
            
            # --- Logika Status (Active/Expired) ---
            try:
                today = DT.date.today()
                exp_dt = DT.datetime.strptime(exp, "%Y-%m-%d").date()
                diff = (exp_dt - today).days
                if diff >= 0: status = f"🟢 Active ({diff} Hari)"
                else: status = f"🔴 Expired ({abs(diff)} Hari Lalu)"
            except: status = "⚪ Unlimited"

            # --- Format Tampilan Card (Sama untuk List & Delete) ---
            msg += f"""
<b>👤 User :</b> <code>{user}</code>
<b>📅 Exp  :</b> <code>{exp}</code>
<b>💎 Stat :</b> {status}
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
"""
            # --- Pembuatan Tombol Berdasarkan Mode ---
            if mode == "list":
                # Tombol Detail: Callback vDetail_USER_PAGE
                flat_buttons.append(Button.inline(f"🔍 {user}", data=f"vDetail_{user}_{page}"))
            else:
                # Tombol Hapus: Callback delExec_USER_PAGE
                flat_buttons.append(Button.inline(f"🗑️ {user}", data=f"delExec_{user}_{page}"))

    # Footer Pesan
    if mode == "delete" and sliced_data:
        msg += "\n<i>Klik tombol user di bawah untuk menghapus:</i>"
        
    msg += f"\n📊 <b>Total:</b> {total_items} Users | 📄 <b>Page:</b> {page+1}/{total_pages}"

    # --- Chunking Tombol (Grid 2 Kolom) ---
    # Mengubah [A, B, C, D] menjadi [[A, B], [C, D]] agar rapi
    grid_buttons = [flat_buttons[i:i + 2] for i in range(0, len(flat_buttons), 2)]
    
    return msg, total_pages, grid_buttons

# =================================================================
# 1. MENU UTAMA VMESS
# =================================================================
@bot.on(events.CallbackQuery(data=b'vmess'))
async def vmess_menu(event):
    sender = await event.get_sender()
    try:
        if valid(str(sender.id)) != "true":
            return await event.answer("Access Denied", alert=True)
    except: pass # Bypass jika fungsi valid tidak ada

    try:
        # Cek Info Server (Opsional)
        try:
            z = requests.get("http://ip-api.com/json/?fields=country,isp", timeout=2).json()
            isp = z.get("isp", "Unknown")
            country = z.get("country", "Unknown")
        except:
            isp, country = "Unknown", "Unknown"
        
        # Ambil Domain
        try: my_domain = DOMAIN
        except: my_domain = "Premium Server"

        msg = f"""
<b>⚡ VMESS MANAGER</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🟢 Service Status :</b> <code>Active</code>
<b>🌐 Hostname/IP    :</b> <code>{my_domain}</code>
<b>📡 ISP Provider   :</b> <code>{isp}</code>
<b>🌍 Region/City    :</b> <code>{country}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
        inline = [
            [Button.inline("⚡ TRIAL", "trial-vmess"), Button.inline("⚡ CREATE", "create-vmess")],
            [Button.inline("📊 LIST USER", "list-vmess"), Button.inline("🗑️ DELETE", "delete-vmess")],
            [Button.inline("‹ Main Menu ›", "menu")]
        ]
        
        await event.edit(msg, buttons=inline, parse_mode='html')
    except Exception as e:
        await event.respond(f"Error Menu: {str(e)}")

# =================================================================
# 2. CREATE VMESS (UPDATE: DENGAN IP LIMIT)
# =================================================================
@bot.on(events.CallbackQuery(data=b'create-vmess'))
async def create_vmess(event):
    chat = event.chat_id
    sender = await event.get_sender()
    try:
        if valid(str(sender.id)) != "true":
            return await event.answer("Akses Ditolak", alert=True)
    except: pass

    async def create_vmess_process(event):
        try:
            # 1. Input Username
            async with bot.conversation(chat, timeout=60) as user_convo:
                await event.respond('<b>👤 Input Username:</b>', parse_mode='html')
                user_event = await user_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                user = user_event.raw_text.strip()
            
            # 2. Input Quota (GB)
            async with bot.conversation(chat, timeout=60) as quota_convo:
                await event.respond("<b>💾 Input Quota (GB):</b>", parse_mode='html')
                quota_event = await quota_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                quota = quota_event.raw_text.strip()

            # 3. Input IP Limit (NEW)
            async with bot.conversation(chat, timeout=60) as ip_convo:
                await event.respond("<b>📱 Input IP Limit (Angka):</b>", parse_mode='html')
                ip_event = await ip_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                iplimit = ip_event.raw_text.strip()
            
            # 4. Input Expired (Hari)
            async with bot.conversation(chat, timeout=60) as exp_convo:
                await event.respond("<b>📅 Input Expired (Hari):</b>", parse_mode='html')
                exp_event = await exp_convo.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                exp = exp_event.raw_text.strip()

            msg_load = await event.respond("<code>Processing...</code>", parse_mode='html')
            
            # Eksekusi Script (Menambahkan iplimit ke argumen)
            # Urutan: User -> Exp -> Quota -> IPLimit
            cmd = f'printf "%s\n" "{user}" "{exp}" "{quota}" "{iplimit}" | addws-bot'
            
            try:
                a = subprocess.check_output(cmd, shell=True).decode("utf-8")
                
                links = [x.group() for x in re.finditer("vmess://(.*)", a)]
                if not links: raise Exception("Link tidak ditemukan")
                
                z = base64.b64decode(links[0].replace("vmess://","")).decode("ascii")
                d = json.loads(z)
                
                link_tls  = links[0].strip()
                link_ntls = links[1].strip() if len(links) > 1 else ""
                link_grpc = links[2].strip() if len(links) > 2 else "" # GRPC
                
                today = DT.date.today()
                later = today + DT.timedelta(days=int(exp))
                
                msg = f"""
<b>✅ VMESS PREMIUM CREATED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 Username  :</b> <code>{d["ps"]}</code>
<b>🌐 Domain    :</b> <code>{d["add"]}</code>
<b>💾 Quota     :</b> <code>{quota} GB</code>
<b>📱 IP Limit  :</b> <code>{iplimit} IP</code>
<b>📅 Expired   :</b> <code>{later}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔗 LINKS</b>
<b>🔮 TLS  :</b> <code>{link_tls}</code>

<b>🔮 NTLS :</b> <code>{link_ntls}</code>

<b>🔮 GRPC :</b> <code>{link_grpc}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
                await msg_load.delete()
                await event.respond(msg, parse_mode='html', buttons=[[Button.inline("‹ Main Menu ›", "menu")]])
            except Exception as e:
                await msg_load.delete()
                await event.respond(f"<b>❌ Error:</b> {str(e)}", buttons=[[Button.inline("‹ Kembali ›", "menu")]], parse_mode='html')
                
        except asyncio.TimeoutError:
            await event.respond("<b>❌ Waktu Habis (Timeout)</b>", parse_mode='html')
        except Exception as e:
            await event.respond(f"<b>❌ Error System:</b> {str(e)}", parse_mode='html')

    await create_vmess_process(event)

# =================================================================
# 3. TRIAL VMESS (INPUT MANUAL)
# =================================================================
@bot.on(events.CallbackQuery(data=b'trial-vmess'))
async def trial_vmess(event):
    chat = event.chat_id
    sender = await event.get_sender()
    try:
        if valid(str(sender.id)) != "true":
            return await event.answer("Akses Ditolak", alert=True)
    except: pass

    async def trial_vmess_process(event):
        try:
            # --- BAGIAN INI DIUBAH MENJADI CONVERSATION INPUT ---
            async with bot.conversation(chat, timeout=60) as conv:
                # 1. Minta Input Waktu
                await event.respond("<b>⏱️ Input Durasi Trial (Menit):</b>\n<i>Contoh: 30</i>", parse_mode='html')
                
                try:
                    # Tunggu User Mengetik
                    resp = await conv.wait_event(events.NewMessage(incoming=True, from_users=sender.id))
                    exp = resp.raw_text.strip()
                    
                    # Validasi: Pastikan yang diinput adalah angka
                    if not exp.isdigit():
                        return await event.respond("<b>❌ Error:</b> Harap masukkan angka saja (contoh: 30).", parse_mode='html')
                        
                except asyncio.TimeoutError:
                    return await event.respond("<b>❌ Waktu Habis (Timeout)</b>", parse_mode='html')
            
            # --- PROSES PEMBUATAN AKUN (SAMA SEPERTI SEBELUMNYA) ---
            msg_load = await event.respond("<code>Creating Trial...</code>", parse_mode='html')
            
            # Eksekusi Script Trial dengan input waktu dari user
            cmd = f'printf "%s\n" "{exp}" | bot-trialws'
            
            try:
                a = subprocess.check_output(cmd, shell=True).decode("utf-8")
                
                # Regex link
                links = [x.group() for x in re.finditer("vmess://(.*)", a)]
                if not links: raise Exception("Gagal generate link trial")

                # Decode info user
                z = base64.b64decode(links[0].replace("vmess://","")).decode("ascii")
                d = json.loads(z)

                link_tls  = links[0].strip()
                link_ntls = links[1].strip() if len(links) > 1 else ""
                link_grpc = links[2].strip() if len(links) > 2 else ""

                msg = f"""
<b>✅ VMESS TRIAL CREATED</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>👤 Username  :</b> <code>{d["ps"]}</code>
<b>⏳ Expired   :</b> <code>{exp} Menit</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔗 LINKS</b>
<b>🔮 TLS  :</b> <code>{link_tls}</code>

<b>🔮 NTLS :</b> <code>{link_ntls}</code>

<b>🔮 GRPC :</b> <code>{link_grpc}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
                await msg_load.delete()
                await event.respond(msg, parse_mode='html', buttons=[[Button.inline("‹ Main Menu ›", "menu")]])
            except Exception as e: 
                await msg_load.delete()
                await event.respond(f"❌ <b>Gagal:</b> Script error atau format salah.\nDetail: {e}", parse_mode='html')
                
        except Exception as e:
            await event.respond(f"Error System: {e}")

    await trial_vmess_process(event)

# =================================================================
# 4. LIST VMESS (VIEW & PAGINATION)
# =================================================================
@bot.on(events.CallbackQuery(data=b'list-vmess'))
async def list_vmess_handler(event):
    sender = await event.get_sender()
    try:
        if valid(str(sender.id)) != "true": return
    except: pass

    data_list = get_vmess_data()
    msg, total_pages, user_buttons = render_page_content(data_list, 0, mode="list")
    
    nav_buttons = []
    if total_pages > 1:
        nav_buttons.append(Button.inline("Next ⏩", data=f"vmessPage_1"))
    
    all_buttons = user_buttons + [nav_buttons] + [[Button.inline("‹ Kembali ›", "vmess")]]
    
    try: await event.edit(msg, buttons=all_buttons, parse_mode='html')
    except: await event.reply(msg, buttons=all_buttons, parse_mode='html')

@bot.on(events.CallbackQuery(pattern=b"vmessPage_(\d+)"))
async def paginate_vmess(event):
    try: page = int(event.pattern_match.group(1).decode())
    except: page = 0
    
    data_list = get_vmess_data()
    msg, total_pages, user_buttons = render_page_content(data_list, page, mode="list")
    
    nav_buttons = []
    if page > 0: nav_buttons.append(Button.inline("⏪ Prev", data=f"vmessPage_{page-1}"))
    if page < total_pages - 1: nav_buttons.append(Button.inline("Next ⏩", data=f"vmessPage_{page+1}"))
    
    all_buttons = user_buttons + [nav_buttons] + [[Button.inline("‹ Kembali ›", "vmess")]]
    try: await event.edit(msg, buttons=all_buttons, parse_mode='html')
    except: await event.answer("Halaman tidak berubah")

# =================================================================
# 5. DETAIL VMESS (EXECUTE SCRIPT)
# =================================================================
@bot.on(events.CallbackQuery(pattern=b"vDetail_(.+)_(.+)"))
async def detail_vmess(event):
    try:
        user = event.pattern_match.group(1).decode()
        page_origin = event.pattern_match.group(2).decode()
    except: return
    
    try: msg_wait = await event.edit("<b>🔄 Mengambil Detail...</b>", parse_mode='html')
    except: msg_wait = await event.respond("<b>🔄 Mengambil Detail...</b>", parse_mode='html')
    
    try:
        cmd_path = '/usr/bin/kyt/shell/bot/bot-vmess-detail'
        if not os.path.exists(cmd_path):
             return await msg_wait.edit(f"❌ Script tidak ditemukan: {cmd_path}", parse_mode='html')

        subprocess.run(f"chmod +x {cmd_path}", shell=True)
        
        # Eksekusi Script
        cmd = f'{cmd_path} "{user}"'
        process = subprocess.run(cmd, shell=True, check=False, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        raw_data = process.stdout.decode("utf-8").strip()
        
        if not raw_data or "Error" in raw_data:
            await msg_wait.edit(f"❌ <b>Gagal:</b> User {user} tidak ditemukan.", buttons=[[Button.inline("‹ Kembali ›", data=f"vmessPage_{page_origin}")]], parse_mode='html')
            return

        parts = raw_data.split('|')
        if len(parts) < 7:
             return await msg_wait.edit(f"❌ Output Script Format Salah.", buttons=[[Button.inline("‹ Kembali ›", data=f"vmessPage_{page_origin}")]])

        d_user = parts[0]
        d_domain = parts[1]
        d_uuid = parts[2]
        d_exp = parts[3]
        d_quota = parts[4]
        d_ip = parts[5]
        d_tls = parts[6]
        d_ntls = parts[7] if len(parts) > 7 else "-"
        d_grpc = parts[8] if len(parts) > 8 else "-"
        
        msg = f"""
<b>👤 USER DETAILS: {d_user}</b>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🌐 Domain    :</b> <code>{d_domain}</code>
<b>💾 Quota     :</b> <code>{d_quota}</code>
<b>📱 IP Limit  :</b> <code>{d_ip}</code>
<b>📅 Expired   :</b> <code>{d_exp}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔑 KEY CONFIGURATION</b>
<b>🆔 UUID      :</b> <code>{d_uuid}</code>
<b>🛡 AlterId   :</b> <code>0</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>🔗 LINKS</b>
<b>🔮 TLS  :</b> <code>{d_tls}</code>

<b>🔮 NTLS :</b> <code>{d_ntls}</code>

<b>🔮 GRPC :</b> <code>{d_grpc}</code>
▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬▬
<b>» 👤 Telegram Admin : @HookageLegend</b>
"""
        buttons = [[Button.inline("‹ Kembali ke List ›", data=f"vmessPage_{page_origin}")]]
        await msg_wait.edit(msg, buttons=buttons, parse_mode='html', link_preview=False)
    except Exception as e:
        await msg_wait.edit(f"<b>❌ Error:</b> {str(e)}", parse_mode='html')

# =================================================================
# 6. DELETE VMESS (VIEW & EXECUTE)
# =================================================================
@bot.on(events.CallbackQuery(data=b'delete-vmess'))
async def delete_vmess(event):
    sender = await event.get_sender()
    try:
        if valid(str(sender.id)) != "true": return
    except: pass
    
    data_list = get_vmess_data()
    msg, total_pages, del_buttons = render_page_content(data_list, 0, mode="delete")
    
    nav_buttons = []
    if total_pages > 1:
        nav_buttons.append(Button.inline("Next ⏩", data=f"delPage_1"))
        
    all_buttons = del_buttons + [nav_buttons] + [[Button.inline("‹ Kembali ›", "vmess")]]
    
    try: await event.edit(msg, buttons=all_buttons, parse_mode='html')
    except: await event.reply(msg, buttons=all_buttons, parse_mode='html')

@bot.on(events.CallbackQuery(pattern=b"delPage_(\d+)"))
async def paginate_delete_vmess(event):
    try: page = int(event.pattern_match.group(1).decode())
    except: page = 0
    
    data_list = get_vmess_data()
    msg, total_pages, del_buttons = render_page_content(data_list, page, mode="delete")
    
    nav_buttons = []
    if page > 0: nav_buttons.append(Button.inline("⏪ Prev", data=f"delPage_{page-1}"))
    if page < total_pages - 1: nav_buttons.append(Button.inline("Next ⏩", data=f"delPage_{page+1}"))
    
    all_buttons = del_buttons + [nav_buttons] + [[Button.inline("‹ Kembali ›", "vmess")]]
    try: await event.edit(msg, buttons=all_buttons, parse_mode='html')
    except: await event.answer("Halaman tidak berubah")

@bot.on(events.CallbackQuery(pattern=b"delExec_(.+)_(.+)"))
async def delete_vmess_exec(event):
    try:
        user = event.pattern_match.group(1).decode()
        page = int(event.pattern_match.group(2).decode())
    except: return
    
    await event.answer(f"⏳ Menghapus user: {user}...", alert=False)
    
    cmd = f'printf "%s\n" "{user}" | bot-delws' 
    try:
        subprocess.check_output(cmd, shell=True)
        await event.answer(f"✅ User {user} Berhasil Dihapus!", alert=True)
        
        data_list = get_vmess_data()
        msg, total_pages, del_buttons = render_page_content(data_list, page, mode="delete")
        
        nav_buttons = []
        if page > 0: nav_buttons.append(Button.inline("⏪ Prev", data=f"delPage_{page-1}"))
        if page < total_pages - 1: nav_buttons.append(Button.inline("Next ⏩", data=f"delPage_{page+1}"))
        
        all_buttons = del_buttons + [nav_buttons] + [[Button.inline("‹ Kembali ›", "vmess")]]
        await event.edit(msg, buttons=all_buttons, parse_mode='html')
        
    except Exception as e:
        await event.answer(f"❌ Gagal menghapus: {str(e)}", alert=True)